<?php
/**
 * AOS Governance for WP — Uninstall
 *
 * Fired when the plugin is deleted (not deactivated).
 * Removes all plugin data from the database.
 *
 * @package aos-governance
 * @since   1.0.0
 */

// If uninstall not called from WordPress, die.
if (!defined('WP_UNINSTALL_PLUGIN')) {
    die;
}

global $wpdb;

// Remove the audit log table.
$table_name = $wpdb->prefix . 'wpg_audit_log';
// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.DirectDatabaseQuery.SchemaChange, WordPress.DB.PreparedSQL.InterpolatedNotPrepared
$wpdb->query("DROP TABLE IF EXISTS {$table_name}");

// Remove all plugin options.
$options = [
    'wpg_version',
    'wpg_db_version',
    'wpg_policies',
    'wpg_deny_first',
    'wpg_alert_settings',
    'wpg_agent_profiles',
];

foreach ($options as $option) {
    delete_option($option);
}

// Remove transients.
delete_transient('wpg_activated');
delete_transient('wpg_governance_paused');

// Clear any scheduled events.
wp_clear_scheduled_hook('wpg_daily_cleanup');
