<?php
/**
 * WPG Admin Dashboard View
 *
 * @package aos-governance
 * @since   1.0.0
 */

defined('ABSPATH') || exit;

$stats = WPG_Audit_Log::instance()->get_stats('day');
$policies = WPG_Policy_Engine::instance()->get_active_policies();
$recent = WPG_Audit_Log::instance()->query([
    'per_page' => 10,
    'order' => 'DESC',
]);
?>

<div class="wrap wpg-wrap">
    <h1 class="wpg-title">
        <span class="dashicons dashicons-shield"></span>
        <?php esc_html_e('AOS Governance for WP', 'aos-governance'); ?>
        <span class="wpg-version">v<?php echo esc_html(WPG_VERSION); ?></span>
    </h1>

    <p class="wpg-subtitle">
        <?php esc_html_e('Constitutional AI Governance for WordPress MCP. The gate is active.', 'aos-governance'); ?>
    </p>

    <div class="wpg-actions-bar" style="margin-bottom: 20px;">
        <button id="wpg-run-simulation" class="button button-primary" style="background: #e8491d; border-color: #c73e18; font-weight: 600; padding: 6px 20px;">
            🧪 <?php esc_html_e('Run Test Scenarios', 'aos-governance'); ?>
        </button>
        <span id="wpg-sim-status" style="margin-left: 12px; font-style: italic; color: #666;"></span>
    </div>

    <!-- Stats Grid -->
    <div class="wpg-stats-grid">
        <div class="wpg-stat-card">
            <div class="wpg-stat-number"><?php echo esc_html($stats['total']); ?></div>
            <div class="wpg-stat-label"><?php esc_html_e('Actions Today', 'aos-governance'); ?></div>
        </div>
        <div class="wpg-stat-card wpg-stat-success">
            <div class="wpg-stat-number"><?php echo esc_html($stats['allowed']); ?></div>
            <div class="wpg-stat-label"><?php esc_html_e('Allowed', 'aos-governance'); ?></div>
        </div>
        <div class="wpg-stat-card wpg-stat-danger">
            <div class="wpg-stat-number"><?php echo esc_html($stats['denied']); ?></div>
            <div class="wpg-stat-label"><?php esc_html_e('Denied', 'aos-governance'); ?></div>
        </div>
        <div class="wpg-stat-card">
            <div class="wpg-stat-number"><?php echo esc_html(count($policies)); ?></div>
            <div class="wpg-stat-label"><?php esc_html_e('Active Policies', 'aos-governance'); ?></div>
        </div>
        <div class="wpg-stat-card">
            <div class="wpg-stat-number"><?php echo esc_html($stats['deny_rate']); ?>%</div>
            <div class="wpg-stat-label"><?php esc_html_e('Deny Rate', 'aos-governance'); ?></div>
        </div>
    </div>

    <!-- Two Column Layout -->
    <div class="wpg-dashboard-grid">
        <!-- Recent Activity -->
        <div class="wpg-card">
            <h2 class="wpg-card-title">
                <?php esc_html_e('Recent Activity', 'aos-governance'); ?>
                <a href="<?php echo esc_url(admin_url('admin.php?page=wpg-audit-log')); ?>" class="wpg-link">
                    <?php esc_html_e('View All →', 'aos-governance'); ?>
                </a>
            </h2>

            <?php if (empty($recent['entries'])): ?>
                <div class="wpg-empty">
                    <p><?php esc_html_e('No governance events recorded yet. The audit log will populate as AI agents interact with your site through MCP.', 'aos-governance'); ?></p>
                </div>
            <?php
else: ?>
                <table class="wpg-table">
                    <thead>
                        <tr>
                            <th><?php esc_html_e('Time', 'aos-governance'); ?></th>
                            <th><?php esc_html_e('Decision', 'aos-governance'); ?></th>
                            <th><?php esc_html_e('Ability', 'aos-governance'); ?></th>
                            <th><?php esc_html_e('Agent', 'aos-governance'); ?></th>
                            <th><?php esc_html_e('Policy', 'aos-governance'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($recent['entries'] as $entry): ?>
                            <tr class="wpg-row-<?php echo esc_attr($entry['decision']); ?>">
                                <td><code><?php echo esc_html($entry['timestamp']); ?></code></td>
                                <td>
                                    <span class="wpg-badge wpg-badge-<?php echo esc_attr($entry['decision']); ?>">
                                        <?php echo esc_html(strtoupper($entry['decision'])); ?>
                                    </span>
                                </td>
                                <td><code><?php echo esc_html($entry['ability']); ?></code></td>
                                <td><?php echo esc_html($entry['agent']); ?></td>
                                <td><?php echo esc_html($entry['policy_name'] ?: '—'); ?></td>
                            </tr>
                        <?php
    endforeach; ?>
                    </tbody>
                </table>
            <?php
endif; ?>
        </div>

        <!-- Active Policies Sidebar -->
        <div class="wpg-card">
            <h2 class="wpg-card-title">
                <?php esc_html_e('Active Policies', 'aos-governance'); ?>
                <a href="<?php echo esc_url(admin_url('admin.php?page=wpg-policies')); ?>" class="wpg-link">
                    <?php esc_html_e('Manage →', 'aos-governance'); ?>
                </a>
            </h2>

            <?php if (empty($policies)): ?>
                <div class="wpg-empty">
                    <p><?php esc_html_e('No active policies. All AI agent actions are currently ungovemed.', 'aos-governance'); ?></p>
                </div>
            <?php
else: ?>
                <ul class="wpg-policy-list">
                    <?php foreach ($policies as $policy): ?>
                        <li class="wpg-policy-item">
                            <span class="wpg-policy-indicator wpg-indicator-<?php echo esc_attr($policy['decision'] ?? 'deny'); ?>"></span>
                            <div>
                                <strong><?php echo esc_html($policy['name']); ?></strong>
                                <small><?php echo esc_html($policy['description'] ?? ''); ?></small>
                            </div>
                            <span class="wpg-priority">P<?php echo esc_html($policy['priority'] ?? 100); ?></span>
                        </li>
                    <?php
    endforeach; ?>
                </ul>
            <?php
endif; ?>

            <!-- Quick Info -->
            <div class="wpg-info-box">
                <h3><?php esc_html_e('Gate Status', 'aos-governance'); ?></h3>
                <div class="wpg-gate-status">
                    <?php if (get_transient('wpg_governance_paused')): ?>
                        <span class="wpg-badge wpg-badge-warning"><?php esc_html_e('PAUSED', 'aos-governance'); ?></span>
                    <?php
else: ?>
                        <span class="wpg-badge wpg-badge-active"><?php esc_html_e('ACTIVE', 'aos-governance'); ?></span>
                    <?php
endif; ?>
                </div>
                <p class="wpg-info-detail">
                    <?php esc_html_e('The policy gate evaluates every AI ability execution against your active policies before allowing the action to proceed.', 'aos-governance'); ?>
                </p>
                <ul class="wpg-info-specs">
                    <li><?php esc_html_e('Zero LLM in governance loop', 'aos-governance'); ?></li>
                    <li><?php esc_html_e('Zero external API calls', 'aos-governance'); ?></li>
                    <li><?php esc_html_e('<1ms gate evaluation', 'aos-governance'); ?></li>
                    <li><?php esc_html_e('100% deterministic', 'aos-governance'); ?></li>
                </ul>
            </div>
        </div>
    </div>
</div>
