<?php
defined('ABSPATH') || exit;
$cd = sanitize_text_field($_GET['decision'] ?? '');
$ca = sanitize_text_field($_GET['ability'] ?? '');
$cg = sanitize_text_field($_GET['agent'] ?? '');
$cp = max(1, (int)($_GET['paged'] ?? 1));
$pp = 25;
$f = ['per_page'=>$pp,'page'=>$cp,'order'=>'DESC'];
if($cd){$f['decision']=$cd;}
if($ca){$f['ability']=$ca;}
if($cg){$f['agent']=$cg;}
$r = WPG_Audit_Log::instance()->query($f);
$entries=$r['entries'];$total=$r['total'];$pages=$r['pages'];
?>
<div class="wrap wpg-wrap">
<h1 class="wpg-title"><span class="dashicons dashicons-shield"></span><?php esc_html_e('Audit Log','aos-governance');?><span class="wpg-version">v<?php echo esc_html(WPG_VERSION);?></span></h1>
<p class="wpg-subtitle"><?php esc_html_e('Immutable record of every AI governance decision.','aos-governance');?></p>
<form method="get" class="wpg-filters">
<input type="hidden" name="page" value="wpg-audit-log">
<select name="decision"><option value="">All Decisions</option><option value="allow" <?php selected($cd,'allow');?>>Allowed</option><option value="deny" <?php selected($cd,'deny');?>>Denied</option></select>
<input type="text" name="ability" value="<?php echo esc_attr($ca);?>" placeholder="Filter by ability..." style="min-width:200px;">
<input type="text" name="agent" value="<?php echo esc_attr($cg);?>" placeholder="Filter by agent..." style="min-width:160px;">
<button type="submit" class="button">Filter</button>
<?php if($cd||$ca||$cg):?><a href="<?php echo esc_url(admin_url('admin.php?page=wpg-audit-log'));?>" class="button">Clear</a><?php endif;?>
<span class="wpg-filter-count"><?php printf('%d entries',$total);?></span>
</form>
<div class="wpg-card" style="padding:0;">
<?php if(empty($entries)):?>
<div class="wpg-empty"><h3>No audit log entries found</h3><p>The audit log populates as AI agents interact with your site, or when you run a simulation.</p><p><a href="<?php echo esc_url(admin_url('admin.php?page=wpg-dashboard'));?>" class="button button-primary">Go to Dashboard to Run Simulation</a></p></div>
<?php else:?>
<table class="wpg-table"><thead><tr><th style="width:40px">#</th><th>Time</th><th>Decision</th><th>Ability</th><th>Agent</th><th>Policy</th><th class="wpg-reason-col">Reason</th><th style="width:60px">Speed</th></tr></thead><tbody>
<?php foreach($entries as $e):?>
<tr class="wpg-row-<?php echo esc_attr($e['decision']);?>">
<td><small style="color:#999"><?php echo esc_html($e['id']);?></small></td>
<td><code style="font-size:11px"><?php echo esc_html(wp_date('M j, g:i:s a',strtotime($e['timestamp'])));?></code></td>
<td><span class="wpg-badge wpg-badge-<?php echo esc_attr($e['decision']);?>"><?php echo esc_html(strtoupper($e['decision']));?></span></td>
<td><code class="wpg-ability"><?php echo esc_html($e['ability']);?></code></td>
<td><strong><?php echo esc_html($e['agent']);?></strong><?php if(!empty($e['agent_type'])&&$e['agent_type']!=='unknown'):?><br><small class="wpg-text-muted"><?php echo esc_html($e['agent_type']);?></small><?php endif;?></td>
<td><?php if(!empty($e['policy_name'])&&$e['policy_name']!=='Default Allow'):?><strong><?php echo esc_html($e['policy_name']);?></strong><br><small class="wpg-text-muted"><?php echo esc_html($e['policy_id']);?></small><?php else:?><span class="wpg-text-muted">Default</span><?php endif;?></td>
<td class="wpg-reason-col"><small><?php echo esc_html(wp_trim_words($e['reason'],15,'...'));?></small></td>
<td><code style="font-size:11px"><?php echo esc_html(round((float)$e['elapsed_ms'],2));?>ms</code></td>
</tr>
<?php endforeach;?>
</tbody></table>
<?php if($pages>1):$bu=admin_url('admin.php?page=wpg-audit-log');if($cd)$bu.='&decision='.urlencode($cd);if($ca)$bu.='&ability='.urlencode($ca);if($cg)$bu.='&agent='.urlencode($cg);?>
<div class="wpg-pagination"><?php echo paginate_links(['base'=>$bu.'%_%','format'=>'&paged=%#%','current'=>$cp,'total'=>$pages,'prev_text'=>'&laquo;','next_text'=>'&raquo;']);?></div>
<?php endif;endif;?>
</div>
</div>
